<?php
/**
 * Database Configuration
 * Civil Registry Records Management System
 */

// Load environment configuration
require_once __DIR__ . '/env_loader.php';

// Database connection parameters
// Uses .env file if exists, otherwise falls back to defaults (for localhost)
define('DB_HOST', env('DB_HOST', 'localhost'));
define('DB_USER', env('DB_USER', 'root'));
define('DB_PASS', env('DB_PASS', ''));
define('DB_NAME', env('DB_NAME', 'iscan_db'));

// Database connection using PDO
try {
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);

} catch (PDOException $e) {
    die("Database connection error: " . $e->getMessage());
}

// Application settings
define('APP_NAME', env('APP_NAME', 'Civil Registry Records Management System'));
define('APP_SHORT_NAME', env('APP_SHORT_NAME', 'iSCAN'));
define('APP_VERSION', env('APP_VERSION', '1.0.0'));

// Paths
define('BASE_PATH', dirname(__DIR__));
define('UPLOAD_PATH', BASE_PATH . '/uploads/');
define('UPLOAD_DIR', BASE_PATH . '/uploads/'); // Alias for compatibility
define('ASSETS_PATH', BASE_PATH . '/assets/');

// URLs (adjust if needed)
define('BASE_URL', env('BASE_URL', '/iscan/'));

// Timezone
date_default_timezone_set(env('TIMEZONE', 'Asia/Manila'));

// Error logging configuration
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/php_errors.log');

// Display errors only in development
if (isDevelopment()) {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);
}

// Security Configuration
define('SESSION_TIMEOUT', (int)env('SESSION_TIMEOUT', 3600)); // 1 hour default
define('ENABLE_CSRF_PROTECTION', env('ENABLE_CSRF_PROTECTION', true));
define('ENABLE_RATE_LIMITING', env('ENABLE_RATE_LIMITING', true));
define('MAX_LOGIN_ATTEMPTS', (int)env('MAX_LOGIN_ATTEMPTS', 5));
define('RATE_LIMIT_WINDOW', (int)env('RATE_LIMIT_WINDOW', 300)); // 5 minutes
define('ACCOUNT_LOCKOUT_DURATION', (int)env('ACCOUNT_LOCKOUT_DURATION', 900)); // 15 minutes

// Password Policy
define('MIN_PASSWORD_LENGTH', (int)env('MIN_PASSWORD_LENGTH', 8));
define('REQUIRE_PASSWORD_COMPLEXITY', env('REQUIRE_PASSWORD_COMPLEXITY', false));
define('PASSWORD_EXPIRY_DAYS', (int)env('PASSWORD_EXPIRY_DAYS', 90));

// Maximum file upload size (adjust as needed)
define('MAX_FILE_SIZE', (int)env('MAX_FILE_SIZE', 5242880)); // 5MB in bytes
$allowed_types = env('ALLOWED_FILE_TYPES', 'pdf');
define('ALLOWED_FILE_TYPES', is_array($allowed_types) ? $allowed_types : explode(',', $allowed_types));
